<?php
class bbs
{
	private $db;
	private $thread_table;
	private $forum_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->thread_table=LA_PRE.'thread';
		$this->forum_table=LA_PRE.'forum';
	}

	function threadlist($tid=0,$fid=0,$userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$tid?' AND tid='.$tid:' AND tid=0';
		$where.=$fid?' AND fid='.$fid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND updatetime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND updatetime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND name LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->thread_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function replylist($tid=0,$fid=0,$userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$tid?' AND tid='.$tid:' AND tid!=0';
		$where.=$fid?' AND fid='.$fid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND updatetime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND updatetime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND name LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->thread_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function formatthreadurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-thread-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(19);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],19);

			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'thread-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=thread&tid='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/thread-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=thread&tid='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function formatforumurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-forum-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(19);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],19);

			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'forum-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=forum&fid='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/forum-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=forum&fid='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function thread_settop($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;
		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);

		$tiao=$settings['top_type']==0?$_point:$_amount;
		if($settings['top_fee']<=$tiao)
		{
			if($settings['top_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['top_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['top_fee'])));
			}
			return $this->db->query("UPDATE `$this->thread_table` SET `$this->thread_table`.`istop`='".(TIME+24*3600)."' WHERE `$this->thread_table`.`id`=$id AND  `$this->thread_table`.`userid`=$userid");
		}
		
		return false;
	}

	function thread_settop2($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;
		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);

		$tiao=$settings['top2_type']==0?$_point:$_amount;
		if($settings['top2_fee']<=$tiao)
		{
			if($settings['top2_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['top2_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['top2_fee'])));
			}
			return $this->db->query("UPDATE `$this->thread_table` SET `$this->thread_table`.`istop2`='".(TIME+24*3600)."' WHERE `$this->thread_table`.`id`=$id AND  `$this->thread_table`.`userid`=$userid");
		}
		
		return false;
	}

	function member_thread_edit($info,$modelid=0,$extend=0,$id)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$id=intval($id);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['updatetime']=TIME;
		$info['ip']=IP;

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));

		
		$this->db->update(LA_PRE.$modelinfo['tbname'],$info,'id='.$id);
		$this->db->update($hash_table,$info,'mid='.$id);
		
		$cacheobj->clear();
		return true;
	}

	
	function member_thread_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['updatetime']=TIME;
		$info['ip']=IP;
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		$this->db->insert($hash_table,$info,true);
		
		$cacheobj->clear();
		return $info['mid'];
	}

	
	function doreply($info,$modelid,$extend)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['mid']=$this->db->insert($this->thread_table,$info,true);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		$this->db->insert($hash_table,$info,true);
		
		$cacheobj->clear();
		return true;
	}

	function thread_setdelete($id)
	{
		$id=intval($id);

		return $this->db->query("DELETE FROM `$this->thread_table` WHERE `$this->thread_table`.`id`=$id");
	}

	function getthread($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->thread_table` WHERE `$this->thread_table`.`id`=$id");
	}

	function threadstatis($moduleid=7,$status=-1)
	{
		global $siteidobj,$_siteid;
		$moduleid=intval($moduleid);
		$status=intval($status);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->thread_table` WHERE $where");
	}

	function threadreply($tid=0)
	{
		global $siteidobj,$_siteid;
		$tid=intval($tid);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->thread_table` WHERE `$this->thread_table`.`tid`=$tid");
	}

	function threadset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getthread($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->thread_table.'_data',$id,$modelobj->subformcount2($cinfo['modelid']));
					$this->db->update($this->thread_table,$info,'id='.$id);
					$this->db->update($hash_table,$info,'mid='.$id);
				}
			}
		}
		return true;
	}

	function thread_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getthread($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->thread_table.'_data',$id,$modelobj->subformcount2($cinfo['modelid']));
					$this->db->mysql_delete($this->thread_table,$id);
					$this->db->mysql_delete($hash_table,$id,'mid');
				}
			}
		}
		return true;
	}

	function admin_thread_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);
	
		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$info['inputtime']=$info['updatetime']=TIME;
		$info['ip']=IP;
		$info['status']=1;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}

	function admin_thread_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		$info['updatetime']=TIME;

		$info['siteid']=intval($_SESSION['siteid']);
		$this->db->update($this->thread_table,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}
	
	function forumlist($moduleid=0,$forumid=0)
	{
		global $page,$_siteid,$siteidobj;
		$moduleid=intval($moduleid);
		$forumid=intval($forumid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$forumid?' AND parentid='.$forumid:' AND parentid=0';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='orderby ASC ,fid ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=25;
		$result=$datalist->getlist($this->forum_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function forum_add($info)
	{
		$info['parentid']?$this->forumparentid($info['parentid']):0;
		$info['siteid']=intval($_SESSION['siteid']);

		$names=array_map('trim',explode("|",$info['name']));
		foreach($names as $name)
		{
			if($name)
			{
				$info['name']=strip_tags($name);
				$this->db->insert($this->forum_table,$info);
			}
		}
		return true;
	}

	function forum_delete($id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->foruminfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$this->db->mysql_delete($this->forum_table,intval($id),'fid');
		$this->db->mysql_delete($this->forum_table,intval($id),'parentid');
		$this->db->mysql_delete($this->thread_table,intval($id),'fid');
		return true;
	}

	function getforumid($moduleid=7)
	{
		$r=$this->db->fetch_one("SELECT * FROM `$this->forum_table` WHERE `$this->forum_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->forum_table`.`fid` ASC");
		return $r?$r['forumid']:0;
	}

	function forum_edit($info,$id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->foruminfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		$info['parentid']?$this->forumparentid($info['parentid']):0;
		return $this->db->update($this->forum_table,$info,'fid='.intval($id));
	}

	function foruminfo($id)
	{
		return $this->db->fetch_one("SELECT * FROM `$this->forum_table` WHERE `$this->forum_table`.`fid`=".intval($id));
	}

	function forumname($id)
	{
		$r=$this->foruminfo($id);
		return $r['name'];
	}

	function parentforumname($id)
	{
		$pid=$this->forumparentid($id);
		$r=$pid?$this->foruminfo($pid):array('name'=>'');
		return $r['name'];
	}

	function forumparentid($id)
	{
		$r=$this->foruminfo($id);
		return $r['parentid'];
	}

	function forum_select($moduleid=7,$parentid=0,$g=3)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->forum_table` WHERE `$this->forum_table`.`moduleid`=".intval($moduleid)." AND `$this->forum_table`.`parentid`=".intval($parentid)." ORDER BY `$this->forum_table`.`orderby` ASC,`$this->forum_table`.`fid` ASC");
		foreach($r as $_r)
		{
			if($g>=2)
			{
				$r2=$this->db->fetch_all("SELECT * FROM `$this->forum_table` WHERE `$this->forum_table`.`moduleid`=".intval($moduleid)." AND `$this->forum_table`.`parentid`=".intval($_r['fid'])." ORDER BY `$this->forum_table`.`orderby` ASC,`$this->forum_table`.`fid` ASC");
				if($r2)
				{
					$str.='<optgroup label="'.$_r['name'].'">';
					foreach($r2 as $_r2)
					{
						if($g>=3)
						{
							$r3=$this->db->fetch_all("SELECT * FROM `$this->forum_table` WHERE `$this->forum_table`.`moduleid`=".intval($moduleid)." AND `$this->forum_table`.`parentid`=".intval($_r2['fid'])." ORDER BY `$this->forum_table`.`orderby` ASC,`$this->forum_table`.`fid` ASC");
							if($r3)
							{
								$str.='<option value="'.$_r2['fid'].'" disabled="disabled">'.$_r2['name'].'</option>';
								foreach($r3 as $_r3)
								{
									$str.='<option value="'.$_r3['fid'].'">|--'.$_r3['name'].'</option>';
								}
							}
							else
							{
								$str.='<option value="'.$_r2['fid'].'">'.$_r2['name'].'</option>';
							}
						}
						else
						{
							$str.='<option value="'.$_r2['fid'].'">'.$_r2['name'].'</option>';
						}
					}
					$str.='</optgroup>';
				}
				else
				{
					$str.='<option value="'.$_r['fid'].'">'.$_r['name'].'</option>';
				}
			}
			else
			{
				$str.='<option value="'.$_r['fid'].'">'.$_r['name'].'</option>';
			}
		}

		return $str;
	}

	function forum_select_cat($moduleid=7,$parentid=0)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->forum_table` WHERE `$this->forum_table`.`moduleid`=".intval($moduleid)." AND `$this->forum_table`.`parentid`=".intval($parentid)." ORDER BY `$this->forum_table`.`orderby` ASC,`$this->forum_table`.`fid` ASC");
		foreach($r as $_r)
		{
			$r2=$this->db->fetch_all("SELECT * FROM `$this->forum_table` WHERE `$this->forum_table`.`moduleid`=".intval($moduleid)." AND `$this->forum_table`.`parentid`=".intval($_r['fid'])." ORDER BY `$this->forum_table`.`orderby` ASC,`$this->forum_table`.`fid` ASC");
			if($r2)
			{
				$str.='<option value="'.$_r['fid'].'">'.$_r['name'].'</option>';
				foreach($r2 as $_r2)
				{
					$str.='<option value="'.$_r2['fid'].'">|--'.$_r2['name'].'</option>';
				}
				$str.='</option>';
			}
			else
			{
				$str.='<option value="'.$_r['fid'].'">'.$_r['name'].'</option>';
			}
		}

		return $str;
	}

	function forumchildren($parentid)
	{
		global $cacheobj;
		
		$data=array();

		$sql="SELECT * FROM `$this->forum_table` WHERE `$this->forum_table`.`parentid`=".intval($parentid)." ORDER BY `$this->forum_table`.`orderby` ASC";
		$data=$cacheobj->get($sql);

		if(!$data)
		{
			$data=$this->db->fetch_all($sql);
			$cacheobj->set($sql,$data);
		}
		return $data;
	}

	function getchildrenfid($fid)
	{
		$t_fid[]=$fid;
		$r=$this->forumchildren($fid);
		$i=1;
		if($r)foreach($r as $_r)
		{
			$t_fid[$i]=$this->getchildrenfid($_r['id']);
			$i++;
		}
		return implode(',',$t_fid);
	}

	function get_childrenfid($fid)
	{
		return explode(',',$this->getchildrenfid($fid));
	}

	function postcount($fid='all',$time='today')
	{
		if($fid=='all')
		{
			if($time!='today')
			{
				return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->thread_table` WHERE 1");
			}
			else
			{
				$starttime=strtotime(date('Y-m-d 00:00:00',TIME));
				return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->thread_table` WHERE 1 AND `$this->thread_table`.`inputtime` >=$starttime");
			}
		}
		else
		{
			if($time!='today')
			{
				return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->thread_table` WHERE `$this->thread_table`.`fid` IN(".implode(',',$this->get_childrenfid($fid)).")");
			}
			else
			{
				$starttime=strtotime(date('Y-m-d 00:00:00',TIME));
				return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->thread_table` WHERE `$this->thread_table`.`fid` IN(".implode(',',$this->get_childrenfid($fid)).") AND `$this->thread_table`.`inputtime` >=$starttime");
			}
		}
	}

	function lastpost($fid)
	{
		return $this->db->fetch_one("SELECT * FROM `$this->thread_table` WHERE `$this->thread_table`.`fid` IN(".implode(',',$this->get_childrenfid($fid)).") ORDER BY id DESC");
	}

	function lastthread($tid)
	{
		$r= $this->db->fetch_one("SELECT * FROM `$this->thread_table` WHERE `$this->thread_table`.`tid`=".intval($tid)." ORDER BY id DESC LIMIT 0,1");
		if(!$r)
		{
			return $this->getthread($tid);
		}
		else
		{
			return $r;
		}
	}
}
?>